/**********************************************************************
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : cfgapi.h
 ļ : cfgͷļ, ṹͺ


 ޶¼ :
          1  : Ծ
             : 2007-10-23
             :

**********************************************************************/
#ifndef __CFGAPI_H__
#define __CFGAPI_H__

#include "tbstype.h"
#include "tbsutil.h"
#include "tbserror.h"


#ifdef _cplusplus
    #if _cplusplus
        extern "C" {
    #endif
#endif


/******************************************************************************
 *                                 MACRO                                      *
 ******************************************************************************/



#define CFG_OK              TBS_SUCCESS
#define CFG_FAIL            TBS_FAILED

#define ERR_CFG_MALLOC_FAIL     ERR_MALLOC_FAILED
#define ERR_CFG_BUF_NOT_ENOUGH  ERR_BUF_NOT_ENOUGH
#define ERR_CFG_INTERNAL_ERR    ERR_INTERNAL_ERR
#define ERR_CFG_PARA_INVALID    ERR_PARA_INVALID

#define ERR_CFG_FILE_OPEN       ERR_FILE_OPEN
#define ERR_CFG_FILE_READ       ERR_FILE_READ
#define ERR_CFG_FILE_WRITE      ERR_FILE_WRITE
#define ERR_CFG_FILE_CHKSUM     ERR_FILE_CHKSUM
#define ERR_CFG_NOT_SUPPORT     ERR_NOT_SUPPORT_FUNCTION



#define CFG_PASSIVE_NOTI  1
#define CFG_ACTIVE_NOTI   2

#define CFG_NO_WRITABLE  0
#define CFG_WRITABLE     1
#define CFG_ADDABLE      2
#define CFG_DELETABLE    3

#define MAX_CONFIG_SIZE 		(unsigned long)512*1024   	    //512K  bytes


typedef long CFG_RET;


/******************************************************************************
 *                                STRUCT                                      *
 ******************************************************************************/


/* òֵĽṹ */
typedef struct tagST_PARA_VAL
{
    struct tagST_PARA_VAL *pstNext;
    char *pcType;         /* ֵָ, ṹڻȡбʱ,
                             ֶβ */
    char *pcName;         /* ָ */
    char *pcVal;          /* ֵָ
                             ˽ṹڻȡʱ, ʾб,
                             ¸ʽ: attr1="aaa" attr2="abc def"
                             ˽ṹڻȡʱ, ʾǷд,
                             ʽΪ: Writable="0"  Writable="1"
                          */
} ST_PARA_VAL;

#define CFG_FILE_NAME_LEN 32
extern char s_acCfgItemName[CFG_FILE_NAME_LEN];         /*  */
extern char s_acBakCfgItemName[CFG_FILE_NAME_LEN];      /* ű */
extern char s_acCfgConfigFile[CFG_FILE_NAME_LEN];       /* Ĭļ· */
extern char s_acCfgFullConfigFile[CFG_FILE_NAME_LEN];   /* ģļ· */


/******************************************************************************
 *                               FUNCTION                                     *
 ******************************************************************************/


/* Իȡ֪ͨĽӿ */
typedef CFG_RET (*FUNC_NOTI_INFORM)(unsigned char ucNotiType);



/***********************************************************
ӿ:   ͷģڴ
:   pvMem, ͨṩĽӿȡõڴ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_MemFree(void *pvMem);


/***********************************************************
ӿ:   ȡ֪ͨ
:   ppstParaVal: ֪ͨͷַ, ģ,
                      ʹ CFG_MemFree ͷ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNotification(ST_PARA_VAL **ppstParaVal);


/* ֪ͨ */
CFG_RET CFG_ClearNoti(void);


/***********************************************************
ӿ:   ڵֵ
:   pcPath: ڵ·,
        pcVal: ڵֵ,
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_CheckNodeVal(const char *pcPath, const char *pcVal);

/***********************************************************
ӿ:   ýڵ
:   pcPath: ڵ·
        pcVal: Ҫóɵֵ
       pcAccessor: , ҵģʱֱдNULL
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SetNodeVal(const char *pcPath, const char *pcVal, const char *pcAccessor);


/***********************************************************
ӿ:   ȡڵ
:   pcPath: ڵ·
        ppstParaVal: ڵֵͷ
       pcAccessor: , ҵģʱֱдNULL
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNodeVal(const char *pcPath, ST_PARA_VAL **ppstParaVal,
                       const char *pcAccessor);





/***********************************************************
ӿ:   ȡҶڵݺ
:   pcPath: ڵ·,
        pcVal: ڵ״ֵ̬, ڴɵ߷,
        pulLen: pcValЧ,
                , ʵҪ೤.
        pcType  pulTypeLen ͬ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetLeafValAndType(const char *pcPath,
                char *pcVal, unsigned long *pulValLen,
                char *pcType, unsigned long *pulTypeLen);


/***********************************************************
ӿ:    жϽڵǷ
:   pcPath: ڵ·,

ֵ: 0:ɹ
        :ʧ
***********************************************************/

CFG_RET CFG_IsNodeExist(char *pcPath);

/***********************************************************
ӿ:   ýڵ
:   pcPath: ڵ·
        pcType: ڵ, Ϊ
        pcVal: ڵֵ, Ϊ
        ucIsStandard, Ƿ׼ڵ, 0ΪǱ׼ڵ, 1Ϊ׼ڵ
        ucNeedSave, ǷҪ, 0ΪҪ, 1ΪҪ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_AddNode(const char *pcPath, const char *pcType, const char *pcVal,
                 unsigned char ucIsStandard, unsigned char ucNeedSave,
                 unsigned char ucWritable);





/***********************************************************
ӿ:   ýڵ
:   pcPath: ڵ·
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_DelNode(const char *pcPath);


/***********************************************************
ӿ:   ȡڵ
:   pcPath: ڵ·,
        ucNextLevel: Ƿֻ²ӽڵ
        ppstParaInfo: ڵϢͷ
       pcAccessor: , ҵģʱֱдNULL
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNodeName(const char *pcPath, unsigned char ucNextLevel,
                         ST_PARA_VAL **ppstParaInfo, const char *pcAccessor);


/***********************************************************
ӿ:   ýڵ
:   pstAttVal: ·ֵṹ,
       pcAccessor: , ҵģʱֱдNULL
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SetNodeAttr(const ST_PARA_VAL *pstAttSet, const char *pcAccessor);

CFG_RET CFG_CheckNodeAttrSet(const ST_PARA_VAL *pstAttSet, const char *pcAccessor);

/***********************************************************
ӿ:   ýڵ
:   pstAttVal: ·ֵṹ,
       pcAccessor: , ҵģʱֱдNULL
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNodeAttr(const char *pcPath, ST_PARA_VAL **ppstAttVal,
                        const char *pcAccessor);




/***********************************************************
ӿ:   ļ
:   pcFileContent: ļ
        ulLen: ݳ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SetCfgFile(const char *pcFile, unsigned long ulLen);

/***********************************************************
ӿ:   ȡѹļļ
:   pcFile: ѹļ·
        ulLen: ݳ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SetCompressCfgFile(const char *pcFile, unsigned long ulLen);

/***********************************************************
ӿ:   ļ
:   pcFileContent: 
        pulLen: 뻺, Ȳ, ʵҪĳ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetCfgFile(char *pcFile, unsigned long *pulLen,
                       unsigned long ulCompress, unsigned long ulOverWrite,
                       const char *pcAccessor);


/***********************************************************
ӿ:   дõָĿ
:   
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SaveCfgTo(const char *pcItem);



/***********************************************************
ӿ:   д
:   
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SaveCfg(void);



/***********************************************************
ӿ:   ÿʼ
:   
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_LibInit(void);


long CFG_LibFinal(void);



/***********************************************************
ӿ:   עڵMID
:   pcPath, ڵ·
        usMID: ģid
ֵ: 0:ɹ
        :ʧ
ע:
1ģĹΧĬΪ,עxxx.1ģ1,xxx.1.yyyԶģ
1ĹΧ
2ͬһ·ע,һεΪ׼.
3ڵ·֧ͨ, ָxxx.{i}.yyy.1ģ1,ʾxxx
еʵģ1
,xxx.{i}.yyyֻʵ1ģ1. ͬʱָxxx.2ģ2,ģ1
ʧȥ
xxx.2Ĺ.

***********************************************************/
CFG_RET CFG_RegisterMID(const char *pcPath, unsigned short usMID);




/***********************************************************
ӿ:   עĴ˽ڵMID
:   pcPath, ڵ·
        usMID: ģid
ֵ: 0:ɹ
        :ʧ
ע:
1pcPath뵽Ҷӽڵ, Ҳ˵CareMID÷ΧΪָڵ.
2ͬһ·ע, ÿЧ.
3ڵ·֧ͨ.ͨĻָضʵڱһģ,
ʵ
ģ鶼Ч.

***********************************************************/
CFG_RET CFG_RegisterCareMID(const char *pcPath, unsigned short usMID);


/***********************************************************
ӿ:   ȡڵMID
:   pcPath, ڵ·
       pusMid, MID
ֵ: 0:ɹ
        :ʧ
ע:
***********************************************************/
CFG_RET CFG_GetNodeMID(const char *pcPath, unsigned short *pusMID);



/***********************************************************
ӿ:   ȡڵMID
:   pcPath, ڵ·
       pcAccessor, ߡҵģʹʱֱӴNULL
       pusMid, MID
       pusCareMIDList, ĵMIDб, 0Ϊ.
       ppvNode, . ģʹʱֱӴNULL
ֵ: 0:ɹ
        :ʧ, Ȩ޷ʵ
ע:
***********************************************************/
CFG_RET CFG_GetNodeMIDList(const char *pcPath, const char *pcAccessor,
                    unsigned short *pusMID, unsigned short * pusCareMIDList,
                    unsigned long *pulCareMIDCount,
                    void **ppvNode, const char *pcVal);






/* ȡýڵѾʹõʵ */
/***********************************************************
ӿ:   ȡǰ󼯺ʹùʵ
:   pcPath, ڵ·
       pulMaxIdx, 
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNodeMaxIdx(const char *pcPath, unsigned long *pulMaxIdx);


/* ýڵѾʹõʵ */
/***********************************************************
ӿ:   ȡǰ󼯺ʹùʵ
:   pcPath, ڵ·
        ulMaxIdx, Ҫóɵ
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_SetNodeMaxIdx(const char *pcPath, unsigned long ulMaxIdx);


/* ȡýڵ */
/***********************************************************
ӿ:   ȡڵһӽڵ
:   pcPath, ڵ·
       pulCount, 
ֵ: 0:ɹ
        :ʧ
***********************************************************/
CFG_RET CFG_GetNodeChildCount(const char *pcPath, unsigned long *pulCount);




/* ǵݹӿ, ȡһڵ */
/*************************************************************************
ӿ: ǵݹһڵ
:    pvPath, ǰڵָ
        pusMID, ڵmid
ֵ:   NULLʾһڵָ
          NULLʾ
ע:
*************************************************************************/
void *CFG_GetNextNode(void *pvPath, unsigned short *pusMID);


/* ָ */
CFG_RET CFG_RecoverFactSet(const char *pcAccessor);

/* ǰ */
CFG_RET CFG_ClearCfg(void);

#ifdef CONFIG_APPS_LOGIC_WANSELECT
CFG_RET CFG_ClearAllCfg(void);
#endif

/* ע֪ͨĽӿ */
CFG_RET CFG_RegNotiInformIntf(FUNC_NOTI_INFORM pfnNotiInform);

/* ÷ǵݹMIDĻϢ */
CFG_RET CFG_SetMIDAccessInfo(const char *pcPath, const void **ppvTree,
           unsigned short *pusMID, const char *pcAccessor,
           char **ppcPathSave);

/* ǵݹMID, ȡһMID */
const void *CFG_GetNextMID(const void *pvPrev, unsigned short *pusMID,
                                    unsigned char *pucLen);

/* ɾڵĺϷ */
CFG_RET CFG_CheckAndSetNodeDeleting(const char *pcPath, const char *pcAccessor);

/* ýڵֵĽӿ */
CFG_RET CFG_SetNodeAttrVal(const char *pcPath,
         const char *pcAttr, const char *pcVal);

#define CFG_DATA_TREE 0
#define CFG_LOGIC_TREE 1




#ifdef _CFG_DEBUG
CFG_RET CFG_PrintNode(const void *pvTree, const char *pcPath,
                      unsigned long ulLen, void *pvFile);
#endif






/* ʵֱתһṹ */
CFG_RET CFG_GetValToStruct(const char *pcPath, void *pvStruct,
                           char * const *ppcLeafList,
                           unsigned long ulLeafNum);

/* ͨڵ·ȡһڵбֵһṹ, нڵֵstring */
CFG_RET CFG_GetValToStrArr(const char *pcPath, void *pvStrArr,
                           char * const *ppcLeafList,
                           unsigned long ulLeafNum);


/* ṹеֵõʵ */
CFG_RET CFG_SetValFromStruct(const char *pcPath, const void *pvStruct,
                           char * const *ppcLeafList,
                           unsigned long ulLeafNum);

/* ַеֵõʵ */
CFG_RET CFG_SetValFromStrArr(const char *pcPath, void *pvStrArr,
                           char * const *ppcLeafList,
                           unsigned long ulLeafNum);


/* гָMIDнڵ */
CFG_RET CFG_ListMIDAllNodes(unsigned short usMID, ST_PARA_VAL **ppstParaVal);

/* ½һʵ */
CFG_RET CFG_AddObjInst(const char *pcPath, unsigned long *pulIndex);

/* ȡһڵֵĵַ, ͵ַ */
CFG_RET CFG_GetNodeValPtr(const char *pcPath, const char **ppcVal,
                          const char **ppcType);

#define CFG_MAX_DEPTH         64

#define CFG_MAX_INDEX_DEPTH   16

typedef struct tag_ST_CFG_INST
{
    struct tag_ST_CFG_INST *pstNext;
    unsigned long aulIndexList[CFG_MAX_INDEX_DEPTH];
    char acData[0];

} ST_CFG_INST_NODE;

/* ȡһͨ·µʵĽṹ */
CFG_RET CFG_GetPathInstList(const char *pcMatchPath, char * const *ppcLeafList,
                           unsigned long ulLeafNum,
                           ST_CFG_INST_NODE **ppstInstList);

/* ͨͨ·indexбȡһҶӽڵֵһṹ */
CFG_RET CFG_GetValToStructEx(const char *pcMatchPath,
                           const unsigned long *pulIndexList,
                           void *pvStruct, char * const *ppcLeafList,
                           unsigned long ulLeafNum);

/* ͨڵͨ·һڵбֵ, ֵԴһṹ */
CFG_RET CFG_SetValFromStructEx(const char *pcMatchPath,
                           const unsigned long *pulIndexList,
                           const void *pvStruct, char * const *ppcLeafList,
                           unsigned long ulLeafNum);

/* ȡµmidб, úǰķװ */
CFG_RET CFG_GetObjMIDList(unsigned char ucTree, const char *pcPath,
                unsigned short *pusMIDList, unsigned long *pulCount);

CFG_RET CFG_GetNodeMIDFromFullTree(const char *pcPath, unsigned short *pusMID);

/* ýڵ */
CFG_RET CFG_SetNodeName(const char *pcPath, const char *pcNewName);

/* ͨڵַýڵ */
CFG_RET CFG_SetNodeNameByPtr(void *pvNode, const char *pcNewName);

/* ڵ·Ӧ */
CFG_RET CFG_DelNodeToPtr(const char *pcPath, void **ppvNode);

/* ӵָ· */
CFG_RET CFG_AddNodeFromPtr(const char *pcPath, void *pvNode);

/* Ϊоָmidнڵ׼ */
void CFG_MIDInstListBegin(unsigned short usMID);

/* Ϊоָmidнڵ׼, úָ· */
void CFG_MIDInstListBeginEx(unsigned short usMID, const char *pcPath);

/* , ȡһ ָmidĽڵб */
CFG_RET CFG_ListMIDNextInstNodes(ST_PARA_VAL **ppstParaVal);

/* ȡͨ·Ҷӽڵб */
CFG_RET CFG_GetMatchNodeName(const char *pcMatchPath,
                             unsigned char ucNextLevel,
                             ST_PARA_VAL **ppstParaInfo, const char *pcAccessor);

/* ȡڵֵָ */
CFG_RET CFG_GetNodeAttrValPtr(const char *pcPath, const char *pcAttr,
                              const char **ppcVal);

/* Խڵֵֵָ, ֻintڵ */
CFG_RET CFG_IncIntNodeVal(const char *pcPath, long lVal);


#define CFG_LAST_NODE  0xfffffffe

/* ݽڵ˳ȡڵ */
CFG_RET CFG_GetNodeOrderName(const char *pcPath, unsigned long ulOrder,
                             ST_PARA_VAL **pstPara);

/* ͨ·ڵµʵ */
CFG_RET CFG_ClearObjInstEx(const char *pcMatchPath, unsigned char ucRestIdx);


#ifdef _cplusplus
    #if _cplusplus
        }
    #endif
#endif


#endif /* __CFGAPI_H__ */

